﻿/**********************************
* @file isp.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.20
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU38F20.h"
#include "isp.h"

/* Fuction Declare ----------------------------------------------------------*/

/**********************************
* @fn  unsigned int read_flash(unsigned int read_address_flash)
* @brief read flash
* @param[out].
* @param[in] read_address_flash.
* @return read_data_flash.
**********************************/
unsigned int read_flash(unsigned int read_address_flash);

/* Fuction Define -----------------------------------------------------------*/

/**********************************
* @fn  unsigned int read_flash(unsigned int read_address_flash)
* @brief read flash
* @param[out].
* @param[in] read_address_flash.
* @return read_data_flash.
**********************************/
unsigned int read_flash(unsigned int read_address_flash)
{
	unsigned char read_data_flash = 0;
	GIE = 0;		//关总中断
	EADRL = read_address_flash;			//赋读取地址
	EADRH = read_address_flash >> 8;
	asm("MOVP");			//清除Page latch
	asm("nop");
	read_data_flash = (EDATH << 8) | WORK;	//返回16位数据
	GIE = 1;		//开总中断，读操作结束
	asm("nop");
	return read_data_flash;
}
